﻿var myRecycleBin = {
    context: $(".v-recycle-bin"),
    datatable: null,
    treeview: null,
    selectedItems: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-recycle-bin-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetSurveys", "Home", "Survey"),
            ajaxParams: { "parentFolderId": folder ? folder.Id : 0, "onlyRecycleBin": true },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Key": true, "Type": "numeric" },
                { "Name": "Name", "Title": resources.SurveyName, "Data": "Name", "Class": "itemName", "HideInSelector": true, "Width": "20%" },
                { "Name": "FolderName", "Title": resources.SurveyFolder, "Data": "FolderName", "Class": "itemName", "Width": "20%" },
                { "Name": "DeletedByUserName", "Title": resources.DeletedBy, "Data": "DeletedByUserName" },
                { "Name": "DeletedOn", "Title": resources.DeletionDate, "Data": "DeletedOn", "Type": "datetime" },
                { "Name": "PlannedPurgeDate", "Title": resources.PlannedPurgeDate, "Data": "PlannedPurgeDate", "Type": "date", "Sortable": false }
            ],
            stateKey: "MyRecycleBin",
            stateSaveSorting: false,
            toolBarItems: [
                { "Action": "restore", "Label": resources.Restore, "DisplayCondition": function (data) { return data.CanBeModified; } },
                { "Action": "delete", "Label": resources.PermanentlyDelete, "DisplayCondition": function (data) { return data.CanBeDeleted; } }
            ],
            toolBarClick: function (event, data) {
                var action = data.action;
                var surveyIds = _.pluck(data.rows, "Id");

                if (action == "restore") {
                    myRecycleBin.restoreSurveys(surveyIds);
                }
                else if (action == "delete") {
                    myRecycleBin.deleteSurveys(surveyIds);
                }
            },
            contextMenuItems: [
                { "Action": "restore", "Label": resources.Restore},
                { "Action": "delete", "Label": resources.PermanentlyDelete}
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "restore":
                        myRecycleBin.restoreSurvey(row.Id);
                        break;
                    case "delete":
                        myRecycleBin.deleteSurvey(row.Id, row.EvaluatedStatus);
                        break;
                }
            },
            localizableTexts: { "All": resources.AllSurveys, "Search": resources.SearchSurveys }
        });
    },
    initializeTreeView: function () {
        var actionButtons = [];

        actionButtons.push({ Action: "restore", Label: resources.Restore, Icon: "undo", "DisplayCondition": function (data) { return data.ParentId > 0 && data.CanBeDeleted; }});
        actionButtons.push({ Action: "delete", Label: resources.Delete, Icon: "remove", "DisplayCondition": function (data) { return data.ParentId > 0 && data.CanBeDeleted && data.SurveyFolderStatus == 2; } });
        
        myRecycleBin.treeview = $(".h-recycle-bin-folders", this.context).a4listview({
            ajaxAction: a4.getAction("GetRecycleBinSurveyFolders", "Home", "Survey"),
            saveState: true,
            stateKey: "MyRecycleBin",
            draw: function (event, data) {
                var folder = data.selectedNode;

                if (myRecycleBin.datatable) {
                    myRecycleBin.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folder ? folder.Id : 0 });
                    myRecycleBin.datatable.a4datatable("refresh", true, true);
                }
                else {
                    myRecycleBin.initializeDataTable(folder);
                }

                if (folder)
                    $("#main-header .h-new-survey-menu", myRecycleBin.context).toggle(folder.CanBeModified);
                
                //Toggle treeview
                myRecycleBin.datatable.a4datatable("toggleToolBarItem", "move", data.count > 1);
                $(".v-tableContainer", myRecycleBin.context).toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);
                myRecycleBin.refreshFolderDeleteInformation(folder);
            },
            selectNode: function (event, data) {
                myRecycleBin.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": data.node.Id });
                myRecycleBin.datatable.a4datatable("refresh", true);
                $("#main-header .h-new-survey-menu", myRecycleBin.context).toggle(data.node.CanBeModified);
                
                myRecycleBin.refreshFolderDeleteInformation(data.node);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;
                
                switch (action) {
                    case "restore":
                        myRecycleBin.restoreFolder(node);
                        break;
                    case "delete":
                        myRecycleBin.deleteFolder(node);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchSurveyFolders }
        });
    },
    deleteSurveys: function (surveyIds) {
        modalDialog.showConfirmDialog(confirmDeleteSurveyResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSurveys", "Home", "Survey"), { surveyIds: surveyIds },
                function (result) {
                    myRecycleBin.refreshContent();
                });
        }, 250, 500, true, { "count": surveyIds.length });
    },
    restoreSurveys: function (surveyIds) {
        modalDialog.showConfirmDialog(confirmRestoreSurveyResources, function () {
            a4.callServerMethod(a4.getAction("RestoreSurveys", "Home", "Survey"), { surveyIds: surveyIds },
                function (result) {
                    myRecycleBin.refreshContent();
                });
        }, 250, 500, true, { "count": surveyIds.length });
    },
    deleteFolder: function (folder) {
        modalDialog.showConfirmDialog(confirmDeleteSurveyFolderResources, function () {
            a4.callServerMethod(a4.getAction("DeleteFolder", "Home", "Survey"), { folderId: folder.Id, status: folder.SurveyFolderStatus },
                function (result) {
                    myRecycleBin.refreshContent();
                });
        }, 250, 550, true, { "folderName": folder.Name });
    },
    restoreFolder: function (folder) {
        modalDialog.showConfirmDialog(confirmRestoreSurveyFolderResources, function (includeAllChildItems) {
            a4.callServerMethod(a4.getAction("RestoreFolder", "Home", "Survey"), { folderId: folder.Id, includeAllChildItems: includeAllChildItems },
                function (result) {
                    myRecycleBin.refreshContent();
                    myRecycleBin.refreshFolderDeleteInformation();
                });
        }, 250, 500, true, { "folderName": folder.Name }, { additionalCheckbox: true });
    },
    deleteSurvey: function (surveyId, status) {
        modalDialog.showConfirmDialog(confirmDeleteSurveyResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSurvey", "Home", "Survey"), { surveyId: surveyId, status: status },
                function (result) {
                    myRecycleBin.refreshContent();
                });
        }, 250, 550, true, { "count": 1 });
    },
    restoreSurvey: function (surveyId) {
        modalDialog.showConfirmDialog(confirmRestoreSurveyResources, function () {
            a4.callServerMethod(a4.getAction("RestoreSurvey", "Home", "Survey"), { surveyId: surveyId },
                function (result) {
                    myRecycleBin.refreshContent();
                });
        }, 250, 500, true, { "count": 1 });
    },
    refreshContent: function () {
        myRecycleBin.treeview.a4listview("refresh");
    },
    refreshFolderDeleteInformation: function (folder) {
        $(".v-folder-deleted-info", myRecycleBin.context).html("");
        if (folder && folder.SurveyFolderStatus == 2) {
            var infos = resources.FolderDeletedInfos.replace(/{user}/g, folder.DeleteModifiedByUserName).replace(/{date}/g, folder.LastestDeleteDate).replace(/{plannedPurgeDate}/g, folder.PlannedPurgeDate)
            $(".v-folder-deleted-info", myRecycleBin.context).html(infos);
        }
    }
}

$(document).ready(function () {
    if (myRecycleBin.context.length > 0) {
        myRecycleBin.initializeTreeView();
    }
});